<?php
// public/dashboard.php
declare(strict_types=1);
require_once __DIR__.'/../includes/auth.php';
require_once __DIR__.'/../includes/layout.php';

require_login();
$user = current_user();

$totalUsers = $totalTrainings = $completedEnrollments = 0;

try {
  global $pdo;
  $totalUsers = (int)$pdo->query("SELECT COUNT(*) AS c FROM users")->fetch()['c'];
  $totalTrainings = (int)$pdo->query("SELECT COUNT(*) AS c FROM trainings")->fetch()['c'];
  $completedEnrollments = (int)$pdo->query("SELECT COUNT(*) AS c FROM enrollments WHERE status='completed'")->fetch()['c'];
} catch (Throwable $e) {
  // keep defaults if query fails
}

render_header('Dashboard', 'dashboard'); 
?>

<div class="row">
  <div class="col-lg-4 col-12">
    <div class="small-box bg-info">
      <div class="inner">
        <h3><?= $totalTrainings ?></h3>
        <p>Total Trainings</p>
      </div>
      <div class="icon"><i class="fas fa-chalkboard"></i></div>
    </div>
  </div>
  <div class="col-lg-4 col-12">
    <div class="small-box bg-success">
      <div class="inner">
        <h3><?= $completedEnrollments ?></h3>
        <p>Completed Enrollments</p>
      </div>
      <div class="icon"><i class="fas fa-check-circle"></i></div>
    </div>
  </div>
  <div class="col-lg-4 col-12">
    <div class="small-box bg-warning">
      <div class="inner">
        <h3><?= $totalUsers ?></h3>
        <p>Total Users</p>
      </div>
      <div class="icon"><i class="fas fa-users"></i></div>
    </div>
  </div>
</div>

<div class="card">
  <div class="card-header"><h3 class="card-title">Quick Tips</h3></div>
  <div class="card-body">
    <ul class="mb-0">
      <li>Admins can manage users and trainings.</li>
      <li>HR can encode and track training records.</li>
      <li>Trainers can mark attendance/completions.</li>
      <li>Employees can view and enroll in trainings.</li>
    </ul>
  </div>
</div>

<?php render_footer(); ?>
